# A4 Measure Invariance (hinge single-read)

This repo contains a **self-contained** Python engine and configs to verify the single-read + hash invariance property.

## Structure
- `engine_a4_measure_invariance.py` — stdlib-only engine.
- `config/manifest.json` — run manifest.
- `config/measure.json` — *single-read* measurement scheme.
- `config/hinge.json` — *single-read* hinge metadata.
- `config/diagnostics.json` — tolerances and number of stages.
- `outputs/` — metrics, audits, and run-info produced by the engine.
- `logs/` — environment info and captured stdout/stderr.

## How to run
Detected Python when I ran this: **Python 3.11.8**.
You can re-run exactly with:

```
python /mnt/data/A4_measure_zero_touch/20251105142239/engine_a4_measure_invariance.py --manifest /mnt/data/A4_measure_zero_touch/20251105142239/config/manifest.json --measure /mnt/data/A4_measure_zero_touch/20251105142239/config/measure.json --hinge /mnt/data/A4_measure_zero_touch/20251105142239/config/hinge.json --diag /mnt/data/A4_measure_zero_touch/20251105142239/config/diagnostics.json --out /mnt/data/A4_measure_zero_touch/20251105142239/outputs
```

Or simply:

```
python engine_a4_measure_invariance.py \
  --manifest config/manifest.json \
  --measure  config/measure.json \
  --hinge    config/hinge.json \
  --diag     config/diagnostics.json \
  --out      outputs
```

## Expected success signal
Engine prints a line like:

```
A4 SUMMARY: {"measure_reads": 1, "hinge_reads": 1, "hash_unchanged": true, "PASS": true, "audit_path": "outputs/audits/measure_invariance.json"}
```

and writes `outputs/audits/measure_invariance.json` with `"PASS": true`.
